/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import mjson.Json;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.util.FabricService;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Library;
import net.fabricmc.installer.util.Utils;

public class ClientInstaller {
    public static String install(Path mcDir, String gameVersion, LoaderVersion loaderVersion, InstallerProgress progress) throws IOException {
        System.out.println("Installing " + gameVersion + " with fabric " + loaderVersion.name);
        String profileName = String.format("%s-%s-%s", "fabric-loader", loaderVersion.name, gameVersion);
        Path versionsDir = mcDir.resolve("versions");
        Path profileDir = versionsDir.resolve(profileName);
        Path profileJson = profileDir.resolve(profileName + ".json");
        if (!Files.exists(profileDir, new LinkOption[0])) {
            Files.createDirectories(profileDir, new FileAttribute[0]);
        }
        Path profileJar = profileDir.resolve(profileName + ".jar");
        Files.deleteIfExists(profileJar);
        Json json = FabricService.queryMetaJson(String.format("v2/versions/loader/%s/%s/profile/json", gameVersion, loaderVersion.name));
        Files.write(profileJson, json.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path libsDir = mcDir.resolve("libraries");
        for (Json libraryJson : json.at("libraries").asJsonList()) {
            Library library = new Library(libraryJson);
            Path libraryFile = libsDir.resolve(library.getPath());
            String url = library.getURL();
            progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.download.library.entry")).format(new Object[]{library.name}));
            FabricService.downloadSubstitutedMaven(url, libraryFile);
        }
        progress.updateProgress(Utils.BUNDLE.getString("progress.done"));
        return profileName;
    }
}

