/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class ArgumentParser {
    private final String[] args;
    private Map<String, String> argMap;
    private String command = null;

    private ArgumentParser(String[] args) {
        this.args = args;
        this.parse();
    }

    public String get(String argument) {
        return this.argMap.get(argument);
    }

    public String getOrDefault(String argument, Supplier<String> stringSuppler) {
        String ret = this.argMap.get(argument);
        if (ret == null) {
            ret = stringSuppler.get();
        }
        return ret;
    }

    public boolean has(String argument) {
        return this.argMap.containsKey(argument);
    }

    public Optional<String> getCommand() {
        return this.command == null ? Optional.empty() : Optional.of(this.command);
    }

    private void parse() {
        this.argMap = new HashMap<String, String>();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].startsWith("-")) {
                String key = this.args[i].substring(1);
                String value = null;
                if (i + 1 < this.args.length) {
                    value = this.args[i + 1];
                    if (value.startsWith("-")) {
                        this.argMap.put(key, "");
                        continue;
                    }
                    ++i;
                }
                if (this.argMap.containsKey(key)) {
                    throw new IllegalArgumentException(String.format("Argument %s already passed", key));
                }
                this.argMap.put(key, value);
                continue;
            }
            if (i != 0) continue;
            this.command = this.args[i];
        }
    }

    public static ArgumentParser create(String[] args) {
        return new ArgumentParser(args);
    }
}

